# A Lazy Hessian Evaluation Framework for Accelerating Stochastic Bilevel Optimization

Please refer to the corresponding documentation for the meaning of args.

## How to run the code

### Data hyper-cleaning on MNIST dataset


#### LazyBLO

```python
python3 main_mnist.py --alg=LazyHessian
```

#### AmIGO

```python
python3 main_mnist.py --alg=AmIGO
```

#### stocBiO

```python
python3 main_mnist.py --alg=stocBiO
```

#### MRBO

```python
python3 main_mnist.py --alg=MRBO
```

#### BSA

```python
python3 main_mnist.py --alg=BSA
```


### Deep hyper-representation on CIFAR-10 dataset


#### LazyBLO

```python
python3 main_LazyHessian.py --dataset=cifar10
```

#### AmIGO

```python
python3 main_AmIGO.py --dataset=cifar10
```

#### F2SA

```python
python3 main_F2SA.py --dataset=cifar10
```

#### F3SA

```python
python3 main_F3SA.py --dataset=cifar10
```





